<?php
//  http://localhost/ldp/seed_admin.php

declare(strict_types=1);
require_once __DIR__.'/config/db.php';

$name = 'System Admin';
$email = 'admin@ldp.local';
$plain = 'admin123'; // change after first login
$hash = password_hash($plain, PASSWORD_DEFAULT);

try {
    // Check if admin exists
    $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->execute([$email]);
    
    if ($stmt->rowCount() > 0) {
        echo "Admin already exists: $email";
    } else {
        $stmt = $pdo->prepare("INSERT INTO users (name,email,password,role,status) VALUES (?,?,?,?,?)");
        $stmt->execute([$name, $email, $hash, 'admin', 'active']);
        echo "Admin created: $email / $plain";
    }
} catch (Throwable $e) {
    echo "Seeder error: " . $e->getMessage();
}

